<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
* User
*/
class Users extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();

       	$this->data['page_name'] = "Users";

       	/**
       	 * Loading Model
       	 */
       	$this->load->model('user_model');
       	$this->load->model('user_role_model');
        $this->load->model('user_resource_model');

        $this->data['user_roles'] = $this->user_role_model->get();
	}

	public function index()
	{
		$this->data['users'] = $this->user_model->get();
		$this->load->view('users/index',$this->data);
	}

	public function create()
	{
		
		$this->form_validation->set_rules(array(
            array(
                'field' => 'f_name',
                'label' => 'First Name',
                'rules' => 'required',
                'errors' => array(
                        'required' => '%s cannot be left blank.',
                ),
            ),
            array(
                'field' => 'l_name',
                'label' => 'Last Name',
                'rules' => 'required',
                'errors' => array(
                        'required' => '%s cannot be left blank.',
                ),
			),
			array(
                'field' => 'username',
                'label' => 'User Name',
                'rules' => 'required|is_unique[user.username]',
                'errors' => array(
                        'required' => '%s cannot be left blank.',
                        'is_unique' => '%s already exists.'
                ),
			),
			array(
                'field' => 'password',
                'label' => 'Password',
                'rules' => 'required',
                'errors' => array(
                        'required' => '%s cannot be left blank.',
                ),
			),
			array(
                'field' => 'phone_no',
                'label' => 'Phone Number',
                'rules' => 'required|numeric',
                'errors' => array(
                        'required'  => '%s cannot be left blank.',
                        'numeric'   => '%s must contain only numbers.' 
                ),
			),
			array(
                'field' => 'address',
                'label' => 'Address',
                'rules' => 'required',
                'errors' => array(
                        'required' => '%s cannot be left blank.',
                ),
			),
			array(
                'field' => 'city',
                'label' => 'City',
                'rules' => 'required',
                'errors' => array(
                        'required' => '%s cannot be left blank.',
                ),
			)
        ));

        if($this->form_validation->run()){
        	if($this->user_model->insert()) {
        		set_alert('success','New User Created Successfully.' );
        		redirect(base_url('users'));
        	} else {
        		set_alert('error','Error while creating New User.' );
        	}
        }
		$this->load->view('users/create',$this->data);
	}

    public function view()
    {
        $this->data['user'] = $this->user_model->get($this->input->post('view_id'));
        $this->data['user_resource_type'] = $this->user_resource_model->getUserResourceTypes($this->data['user']->role_ID);
        $this->data['user_resource_data'] = $this->user_resource_model->getUserResourceData($this->data['user']->user_ID);
        $this->load->view('users/view',$this->data);
    }

	public function edit()
	{
        $this->data['user'] = $this->user_model->get($this->input->post('edit_id'));
        $this->data['user_resource_type'] = $this->user_resource_model->getUserResourceTypes($this->data['user']->role_ID);
        $this->data['user_resource_data'] = $this->user_resource_model->getUserResourceData($this->data['user']->user_ID);
		$this->load->view('users/edit',$this->data);
	}

    public function update()
    {
        if($this->user_model->update()!==false) {
            if($this->user_resource_model->setUserResourceData()) {
                set_alert('success','User Updated successfully');
            }
        } else {
            set_alert('error','Error While updating User');
        }
        redirect(base_url('users'));
    }

	public function delete()
	{
        if( $this->user_model->delete($this->input->post('delete_id')) ){
            set_alert('success','User deleted successfully.');
        } else {
            set_alert('error','Error while deleting User .');
        }
        redirect('users');
	}
}